%% wt_avg_op.m

%% Weighted average function to use with "extend_nary1.m" or
%% "extend_nary2.m". Computes the weighted average
%% (w_1*z_1 + ... + w_M*z_M)/(w_1 + ... + w_M)
 
%% Written by Nilesh N. Karnik - July 23,1998
%% For use with MATLAB 5.1 or higher.

%% Inputs : "X" is a "2M x N" matrix. The first "M" rows contain 
%% (domain elements of) the "Z"s and the last "M" rows contain (domain
%% elements of) the "W"s. The weighted average is computed over every 
%% column. 


function [out] = wt_avg_op(X)


[M1,N] = size(X) ;

Z = X(1 : M1/2 , :) ;
W = X(M1/2 + 1 : M1 , :) ;

out = sum(Z.*W) ./ sum(W) ;

return ;